#CS
: 1.0 (20:52 14.10.2017)
: Astel064
:     HTTP   AutoIt3
 AutoIt3: 3.3.6.1 & 3.3.8.1
 :       UDF  ,    .      , //  UDF   .  : ,   Astel064,   ;        !
 UDF:  http://autoit-script.ru/index.php?topic=24636
:
	_HttpSC_CreateServer
	_HttpSC_ConfigServer
	_HttpSC_StartServer
	_HttpSC_StopServer
	_HttpSC_DeleteServer
	_HttpSC_ServerHandler
	_HttpSC_ServerOptimization
	_HttpSC_ServerCheckIp
	_HttpSC_CreateAnswer
	_HttpSC_CreateBigFileAnswer
	_HttpSC_FileGetMimeType
	_HttpSC_ConvertLastModifiedTime
	_HttpSC_ReqestParse
	_HttpSC_BasicAuthenticate_GetData
	_HttpSC_PostReqestGetData
	_HttpSC_WhileList_Add
	_HttpSC_WhileList_Del
	_HttpSC_ServerGet_BannedUsersIp
	_HttpSC_ServerGet_ConnUsers
	_HttpSC_ServerGet_ServerSockets
	__HttpSC_Encoding_URIDecode

;	#include "Http SC.inc"
;	#include "Http SC Error.inc"
#CE


#include-once
#include <Date.au3>
#include "IniVirtual.au3"


;Global Const $s_HttpSC_DebugDir = @ScriptDir&"\Debug"
Global Const $s_HttpSC_DebugDir = ""
	If $s_HttpSC_DebugDir <> "" Then FileDelete($s_HttpSC_DebugDir&"\*.txt")


; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_CreateServer(ByRef $aBanList, $vIP, $iPort=80, $sServerName="Http SC", $fStart=True, $sLogFile="Http SC.log")
Local $aServer, $i, $iCreatedSockets=0, $hSocket
$aServer = _IniVirtual_Initial("")
_IniVirtual_Write($aServer, "Server", "Port", $iPort)
_IniVirtual_Write($aServer, "Server", "Name", $sServerName)
_IniVirtual_Write($aServer, "Server", "Started", $fStart)
_IniVirtual_Write($aServer, "Server", "LogFile", $sLogFile)
_IniVirtual_Write($aServer, "Server", "BigFilesIni", "")
$aBanList = _IniVirtual_Initial("")


TCPStartup()
	If @Error Then Return SetError(3,0,0)


	If IsArray($vIP) Then
		If UBound($vIP, 0) <> 1 Then Return SetError(1,0,0)
		If $vIP[0] <> UBound($vIP, 1)-1 Then Return SetError(2,0,0)

		If $sLogFile <> "" Then
		Local $hFile
		$hFile = FileOpen($sLogFile, 2)
		FileWrite($hFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>   "&@CRLF)
		FileClose($hFile)
		EndIF
				
		For $i = 1 To $vIP[0]
				If NOT $fStart Then
				_IniVirtual_Write($aServer, "Ip2Sock", $vIP[$i], "0")
				Else
				$hSocket = TCPListen($vIP[$i], $iPort)
					If @Error Then
						If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Err] 	>       "&$vIP[$i]&":"&$iPort&";  #"&@Error&@CRLF)
					_IniVirtual_Write($aServer, "Ip2Sock", $vIP[$i], "0")
					Else
						If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    '"&$hSocket&"'   "&$vIP[$i]&":"&$iPort&@CRLF)
					$iCreatedSockets += 1
					_IniVirtual_Write($aServer, "Ip2Sock", $vIP[$i], $hSocket)
					EndIF
				EndIF
		Next
	Else
		If $sLogFile <> "" Then
		Local $hFile
		$hFile = FileOpen($sLogFile, 2)
			If $sLogFile <> "" Then FileWrite($hFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>   "&@CRLF)
		FileClose($hFile)
		EndIF

			If NOT $fStart Then
			_IniVirtual_Write($aServer, "Ip2Sock", $vIP, "0")
			Else
			$hSocket = TCPListen($vIP, $iPort)
				If @Error Then
					If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Err] 	>       "&$vIP&":"&$iPort&";  #"&@Error&@CRLF)
				_IniVirtual_Write($aServer, "Ip2Sock", $vIP, "0")
				Else
					If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    '"&$hSocket&"'   "&$vIP&":"&$iPort&@CRLF)
				$iCreatedSockets += 1
				_IniVirtual_Write($aServer, "Ip2Sock", $vIP, $hSocket)
				EndIF
			EndIF
	EndIF


Return SetError(0,$iCreatedSockets, $aServer)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_StartServer(ByRef $aServer, ByRef $aBanList)
Local $aIpList, $iPort, $sLogFile, $i, $iCreatedSockets=0, $aDefArray[1][2]=[[0]]
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)

$aIpList = _IniVirtual_ReadSection($aServer, "Ip2Sock")
	If @Error Then $aIpList = $aDefArray
$iPort = _IniVirtual_Read($aServer, "Server", "Port", "80")
$sLogFile = _IniVirtual_Read($aServer, "Server", "LogFile", "")
_IniVirtual_Write($aServer, "Server", "Started", 1)
	If $aIpList[0][0] < 1 Then Return SetError(4,0,0)
_IniVirtual_Write($aServer, "Server", "BigFilesIni", "")

_IniVirtual_Delete($aServer, "DataList")
$aBanList = _IniVirtual_Initial("")

For $i = 1 To $aIpList[0][0]
	If $aIpList[$i][1] > 0 Then ContinueLoop
	$aIpList[$i][1] = TCPListen($aIpList[$i][0], $iPort)
		If NOT @Error Then
		$iCreatedSockets += 1
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    '"&$aIpList[$i][1]&"'   "&$aIpList[$i][0]&":"&$iPort&@CRLF)
		_IniVirtual_Write($aServer, "Ip2Sock", $aIpList[$i][0], $aIpList[$i][1])
		Else
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Err] 	>       "&$aIpList[$i][0]&":"&$iPort&";  #"&@Error&@CRLF)
			_IniVirtual_Write($aServer, "Ip2Sock", $aIpList[$i][0], "0")
		EndIF		
Next

Return SetError(0,$iCreatedSockets,1)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_StopServer(ByRef $aServer, ByRef $aBanList)
Local $aIpList, $sLogFile, $aConnList, $i, $iDeletedSockets=0, $iDisconnetUsers=0, $aDefArray[1][2]=[[0]]
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)
	
$aIpList = _IniVirtual_ReadSection($aServer, "Ip2Sock")
	If @Error Then $aIpList = $aDefArray
$sLogFile = _IniVirtual_Read($aServer, "Server", "LogFile", "")
$aConnList = _IniVirtual_ReadSection($aServer, "USock2UIp")
	If @Error Then $aConnList = $aDefArray
_IniVirtual_Write($aServer, "Server", "Started", 0)
	If $aIpList[0][0] < 1 Then Return SetError(5,0,0)
_IniVirtual_Write($aServer, "Server", "BigFilesIni", "")

For $i = 1 To $aIpList[0][0]
	If $aIpList[$i][1] < 1 Then ContinueLoop
	TCPCloseSocket($aIpList[$i][1])
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  '"&$aIpList[$i][1]&"'  IP  "&$aIpList[$i][0]&" "&@CRLF)
	_IniVirtual_Delete($aServer, "Ip2Sock", $aIpList[$i][0])
	$iDeletedSockets += 1
Next

	If $aConnList[0][0] < 1 Then Return SetError(0, $iDisconnetUsers, $iDeletedSockets)

For $i = 1 To $aConnList[0][0]
	If $aConnList[$i][0] < 1 Then ContinueLoop
	TCPCloseSocket($aConnList[$i][0])
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>   '"&$aConnList[$i][0]&"'  IP  "&$aConnList[$i][1]&" "&@CRLF)
	_IniVirtual_Delete($aServer, "USock2UIp", $aIpList[$i][0])
	$iDisconnetUsers += 1
Next

_IniVirtual_Delete($aServer, "DataList")
$aBanList = _IniVirtual_Initial("")

Return SetError(0, $iDisconnetUsers, $iDeletedSockets)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_DeleteServer(ByRef $aServer, ByRef $aBanList)
Local $iRet=0, $iExt=0, $iError=0
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)
	
	If _IniVirtual_Read($aServer, "Server", "Started", 0) Then
	$iRet = _HttpSC_StopServer($aServer, $aBanList)
	$iExt = @Extended
	EndIF

	If _IniVirtual_Read($aServer, "Server", "LogFile", "") <> "" Then FileWrite(_IniVirtual_Read($aServer, "Server", "LogFile", ""), @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&@CRLF)

$aServer = _IniVirtual_Initial("")

TCPShutdown()
Return SetError($iError, $iExt, $iRet)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ConfigServer(ByRef $aServer, $iMaxConnectedUsers=20, $iMaxUserConnectsIn1Min=6, $iUserBanTimeSec=120, $iBigFilePacketSizeMb=5)
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)

_IniVirtual_Write($aServer, "Config", "MaxConnectedUsers", $iMaxConnectedUsers)
_IniVirtual_Write($aServer, "Config", "MaxUserConnectsIn1Min", $iMaxUserConnectsIn1Min)
_IniVirtual_Write($aServer, "Config", "UserBanTimeSec", $iUserBanTimeSec)
_IniVirtual_Write($aServer, "Config", "BigFilePacketSizeMb", $iBigFilePacketSizeMb)

Return SetError(0,0,1)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ServerCheckIp(ByRef $aServer, $vIP)
Local $iPort, $sLogFile, $i, $hSocket, $iCreatedSockets=0
$iPort = _IniVirtual_Read($aServer, "Server", "Port", "")
$sLogFile = _IniVirtual_Read($aServer, "Server", "LogFile", "")
	If $iPort = "" Then Return SetError(6,0,0)


	If IsArray($vIP) Then
		If UBound($vIP, 0) <> 1 Then Return SetError(1,0,0)
		If $vIP[0] <> UBound($vIP, 1)-1 Then Return SetError(2,0,0)
		
		For $i = 1 To $vIP[0]
			If _IniVirtual_Read($aServer, "Ip2Sock", $vIP[$i], "0") > 0 Then ContinueLoop
			$hSocket = TCPListen($vIP[$i], $iPort)
				If @Error Then
					If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Err] 	>       "&$vIP[$i]&":"&$iPort&";  #"&@Error&@CRLF)
					_IniVirtual_Write($aServer, "Ip2Sock", $vIP[$i], "0")
				Else
						If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    '"&$hSocket&"'   "&$vIP[$i]&":"&$iPort&@CRLF)
					_IniVirtual_Write($aServer, "Ip2Sock", $vIP[$i], $hSocket)
					$iCreatedSockets += 1
				EndIF
		Next
	Else
		If _IniVirtual_Read($aServer, "Ip2Sock", $vIP, "0") < 1 Then
		$hSocket = TCPListen($vIP, $iPort)
			If @Error Then
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Err] 	>       "&$vIP&":"&$iPort&";  #"&@Error&@CRLF)
				_IniVirtual_Write($aServer, "Ip2Sock", $vIP, "0")
			Else
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    '"&$hSocket&"'   "&$vIP&":"&$iPort&@CRLF)
				_IniVirtual_Write($aServer, "Ip2Sock", $vIP, $hSocket)
				$iCreatedSockets += 1
			EndIF
		EndIF
	EndIF

Return SetError(0,0,$iCreatedSockets)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_WhileList_Add(ByRef $aServer, $vIP)
Local $i
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)

	If IsArray($vIP) Then
		If UBound($vIP, 0) <> 1 Then Return SetError(1,0,0)
		If $vIP[0] <> UBound($vIP, 1)-1 Then Return SetError(2,0,0)
		
		For $i = 1 To $vIP[0]
		_IniVirtual_Write($aServer, "WhiteList", $vIP[$i], "1")
		Next
	Else
		_IniVirtual_Write($aServer, "WhiteList", $vIP, "1")
	EndIF

Return SetError(0,0,1)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_WhileList_Del(ByRef $aServer, $vIP)
Local $i
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)

	If IsArray($vIP) Then
		If UBound($vIP, 0) <> 1 Then Return SetError(1,0,0)
		If $vIP[0] <> UBound($vIP, 1)-1 Then Return SetError(2,0,0)
		
		For $i = 1 To $vIP[0]
		_IniVirtual_Delete($aServer, "WhiteList", $vIP[$i])
		Next
	Else
		_IniVirtual_Delete($aServer, "WhiteList", $vIP)
	EndIF

Return SetError(0,0,1)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ReqestParse($sReqest, $sHeader)
Local $aSplit, $i
$aSplit = StringSplit($sReqest, @CRLF, 1)
	If @Error Then Return SetError(7, 0, "")
	If $aSplit[0] < 2 Then Return SetError(7, 0, "")

For $i = 2 To $aSplit[0]
	If StringLeft($aSplit[$i], StringLen($sHeader)+2) = $sHeader&": " Then Return SetError(0, 0, StringTrimLeft($aSplit[$i], StringLen($sHeader)+2))
Next

Return SetError(8, 0, "")
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_CreateAnswer(ByRef $aServer, $vSendData, $sHttpVersion="HTTP/1.1", $sAnswerCode="200 Ok",  $aLastModified="", $sContentType="text/html", $sAdditionalHeaders="", $sAuthenticateRealm="")
Local $sReturn = ""
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)
$sReturn &= $sHttpVersion&' '&$sAnswerCode&@CRLF
$sReturn &= 'Content-Length: '&StringLen($vSendData)&@CRLF
	If $sAnswerCode = "401 Unauthorized" Then
		If $sAuthenticateRealm = "" Then $sAuthenticateRealm = "Authorization required"
		$sReturn &= 'WWW-Authenticate: Basic realm="'&$sAuthenticateRealm&'"'&@CRLF
	EndIF

	If IsArray($aLastModified) AND UBound($aLastModified,0) = 1 AND UBound($aLastModified,1) = 6 Then
		If _DateIsValid( $aLastModified[0]&"/"&$aLastModified[1]&"/"&$aLastModified[2]&" "&$aLastModified[3]&":"&$aLastModified[4]&":"&$aLastModified[5] ) Then;		YYYY/DD/MM hh:mm:ss
		$sReturn &= _DateDayOfWeek(_DateToDayOfWeek($aLastModified[0], $aLastModified[1], $aLastModified[2]),1)&", ";			Mon, ( )
		$sReturn &= $aLastModified[2]&" ";			06 ( )
		$sReturn &= _DateToMonth($aLastModified[1], 1)&" ";			Oct ()
		$sReturn &= $aLastModified[0]&" ";			2017 ()
		$sReturn &= $aLastModified[3]&":"&$aLastModified[4]&":"&$aLastModified[5]&" GMT";			22:53:55 GMT ()
		$sReturn &= @CRLF
		EndIF
	EndIF
$sReturn &= 'Content-Type: '&$sContentType&@CRLF
$sReturn &= 'Connection: Close'&@CRLF
$sReturn &= 'Server: '&_IniVirtual_Read($aServer, "Server", "Name", "HttpSC")&@CRLF
	If $sAdditionalHeaders <> "" Then 
	$sAdditionalHeaders &= @CRLF
	$sAdditionalHeaders = StringReplace($sAdditionalHeaders, @CRLF&@CRLF, @CRLF)
	$sReturn &= $sAdditionalHeaders
	EndIF
$sReturn &= @CRLF
$sReturn &= $vSendData
Return $sReturn
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ConvertLastModifiedTime($sDateTime="") ;		YYYY/MM/DD hh:mm:ss
Local $aSplit, $aDate, $aTime, $aReturn[6]
		If $sDateTime = "" Then $sDateTime = @YEAR&"/"&@MON&"/"&@MDAY&" "&@HOUR&":"&@MIN&":"&@SEC

$aSplit = StringSplit($sDateTime, " ")
	If @Error OR $aSplit[0] <> 2 Then Return SetError(9,0,"")

$aDate = StringSplit($aSplit[1], "/")
	If @Error OR $aDate[0] <> 3 Then Return SetError(9,0,"")

$aTime = StringSplit($aSplit[2], "/")
	If @Error OR $aTime[0] <> 3 Then Return SetError(9,0,"")

$aReturn[0] = $aDate[1]
$aReturn[1] = $aDate[2]
$aReturn[2] = $aDate[3]
$aReturn[3] = $aTime[1]
$aReturn[4] = $aTime[2]
$aReturn[5] = $aTime[3]
	If _DateIsValid( $aReturn[0]&"/"&$aReturn[1]&"/"&$aReturn[2]&" "&$aReturn[3]&":"&$aReturn[4]&":"&$aReturn[5] ) Then Return SetError(9,0,"")

Return SetError(0,0,$aReturn)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_FileGetMimeType($sFile)
Local $vAssoc
$vAssoc = StringSplit($sFile, ".")
	If @Error Then Return "application/octet-stream"
$vAssoc = "."&$vAssoc[$vAssoc[0]]

Switch $vAssoc
	Case ".json"
		Return "application/json"
	Case ".pdf"
		Return "application/pdf"
	Case ".aac"
		Return "audio/aac"
	Case ".mp3"
		Return "audio/mpeg"
	Case ".ogg"
		Return "audio/ogg"
	Case ".wma"
		Return "audio/x-ms-wma"
	Case ".rm"
		Return "audio/vnd.rn-realaudio"
	Case ".wav"
		Return "audio/vnd.wave"
	Case ".webm"
		Return "audio/webm"
	Case ".gif"
		Return "image/gif"
	Case ".jpg", ".jfif", ".jpe", ".jpeg"
		Return "image/jpeg"
	Case ".png"
		Return "image/png"
	Case ".tif"
		Return "image/tiff"
	Case ".ico"
		Return "image/vnd.microsoft.icon"
	Case ".wbmp"
		Return "image/vnd.wap.wbmp"
	Case ".webp"
		Return "image/webp"
	Case ".bmp", ".dib", ".rle"
		Return "image/bmp"
	Case ".css"
		Return "text/css"
	Case ".csv"
		Return "text/csv"
	Case ".html", ".htm", ".xhtml", ".xht"
		Return "text/html"
	Case ".js"
		Return "text/javascript"
	Case ".txt"
		Return "text/plain"
	Case ".xml"
		Return "text/xml"
	Case ".mpg", ".mpeg", ".mp1", ".mp2", ".m1v", ".mpv", ".m1a", ".m2a", ".mpa"
		Return "video/mpeg"
	Case ".mp4"
		Return "video/mp4"
	Case ".ogv"
		Return "video/ogg"
	Case ".webm"
		Return "video/webm"
	Case ".wmv"
		Return "video/x-ms-wmv"
	Case ".flv"
		Return "video/x-flv"
	Case ".3gp"
		Return "video/3gpp"
	Case ELSE
		Return "application/octet-stream"
EndSwitch
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func __HttpSC_SocketToIP($iSocket)		;   IP-  .
    Local $tSockAddr, $aRet
    $tSockAddr = DllStructCreate("short;ushort;uint;char[8]")
    $aRet = DllCall("Ws2_32.dll", "int", "getpeername", "int", $iSocket, "ptr", DllStructGetPtr($tSockAddr), "int*", DllStructGetSize($tSockAddr))
    If Not @error And $aRet[0] = 0 Then
        $aRet = DllCall("Ws2_32.dll", "str", "inet_ntoa", "int", DllStructGetData($tSockAddr, 3))
        If Not @error Then Return $aRet[0]
    EndIf
    Return 0
EndFunc   ;==>SocketToIP








Func _HttpSC_ServerHandler(ByRef $aServer, ByRef $aBanList, $sGetFileFunc, $sPostFunc, $sOtherFunc, $sUserBanFunc="")
Local $sLogFile, $iMaxConnectedUsers, $iMaxUserConnectsIn1Min, $aServerIP, $i, $hSocket, $sUserIP, $aUserBanSect, $aOtherSect, $aIp, $n, $aConnectedUsers, $vUserData, $aUserDataList, $iSendBytes, $sUrl, $aBannedUsers, $iUserBanTimeSec
$sLogFile = _IniVirtual_Read($aServer, "Server", "LogFile", "")
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)
	If _IniVirtual_Read($aServer, "Server", "Started", "0") = 0 Then Return SetError(10,0,0)

	If NOT IsArray($aBanList) Then $aBanList = _IniVirtual_Initial("")


$iMaxConnectedUsers = _IniVirtual_Read($aServer, "Config", "MaxConnectedUsers", "20")
$iMaxUserConnectsIn1Min = _IniVirtual_Read($aServer, "Config", "MaxUserConnectsIn1Min", "6")
$iUserBanTimeSec = _IniVirtual_Read($aServer, "Config", "UserBanTimeSec", "120")



; >> 		     BanList		 << ;
$aIp = _IniVirtual_ReadSectionNames($aBanList)
	If NOT @Error Then 
	For $n = 1 To $aIp[0]
		$aOtherSect = _IniVirtual_ReadSection($aBanList, $aIp[$n])
			If @Error Then ContinueLoop
		For $i = 1 To $aOtherSect[0][0]
			If TimerDiff($aOtherSect[$i][1]) >= 60*1000 Then _IniVirtual_Delete($aBanList, $aIp[$n], $aOtherSect[$i][0])
		Next
	Next
	Else
	$aBanList = _IniVirtual_Initial("")
	EndIF
$aIp = 0
$aOtherSect = 0

$aBannedUsers = _IniVirtual_ReadSection($aServer, "BannedUsers")
	If NOT @Error Then
	For $i = 1 To $aBannedUsers[0][0]
		If TimerDiff($aBannedUsers[$i][1]) >= $iUserBanTimeSec*1000 Then
		_IniVirtual_Delete($aServer, "BannedUsers", $aBannedUsers[$i][0])
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Ban] 	>     IP  "&$aBannedUsers[$i][0]&@CRLF)
		EndIF
	Next
	EndIF



; >> 		  		 << ;
$aServerIP = _IniVirtual_ReadSection($aServer, "Ip2Sock")
	If NOT @Error Then
	For $i = 1 To $aServerIP[0][0]
		$aOtherSect = _IniVirtual_ReadSection($aServer, "USock2UIp")
			If NOT @Error AND $aOtherSect[0][0] >= $iMaxConnectedUsers Then ExitLoop
		
		$hSocket = TCPAccept ($aServerIP[$i][1])
			If @Error OR $hSocket < 1 Then ContinueLoop
		
		$sUserIP = __HttpSC_SocketToIP($hSocket)
			If _IniVirtual_Read($aServer, "WhiteList", $sUserIP, "0") <> 1 Then
				If _IniVirtual_Read($aServer, "BannedUsers", $sUserIP, "") <> "" Then
				TCPCloseSocket($hSocket)
					If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Ban] 	>   "&$hSocket&"  IP  "&$sUserIP&"  IP   "&$aServerIP[$i][0]&" !"&@CRLF)
				ContinueLoop
				EndIF
				_IniVirtual_Write($aBanList, $sUserIP, $hSocket, TimerInit())
				$aUserBanSect = _IniVirtual_ReadSection($aBanList, $sUserIP)
					If NOT @Error AND $aUserBanSect[0][0] > $iMaxUserConnectsIn1Min Then
						If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [Ban] 	>   "&$hSocket&"  IP  "&$sUserIP&"         IP  "&$aServerIP[$i][0]&@CRLF)
					TCPCloseSocket($hSocket)
					_IniVirtual_Write($aServer, "BannedUsers", $sUserIP, TimerInit())
						If $sUserBanFunc <> "" Then Call($sUserBanFunc, $sUserIp, $aServerIP[$i][1], $aServerIP[$i][0])
					ContinueLoop
					EndIF
			EndIF
			
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>   "&$hSocket&"  IP  "&$sUserIP&"     IP  "&$aServerIP[$i][0]&@CRLF)
		_IniVirtual_Write($aServer, "USock2UIp", $hSocket, $sUserIP)
	Next
	EndIF
$aServerIP = 0
$aOtherSect = 0
$aUserBanSect = 0



; >> 		   		 << ;
$aConnectedUsers = _IniVirtual_ReadSection($aServer, "USock2UIp")
	If NOT @Error Then
	For $i = 1 To $aConnectedUsers[0][0]
		$vUserData = _IniVirtual_Read($aServer, "DataList", $aConnectedUsers[$i][0], "")
			If $vUserData <> "" Then ContinueLoop
		$vUserData = TCPRecv($aConnectedUsers[$i][0], 5242880, 1)
			If @Error Then
			TCPCloseSocket($aConnectedUsers[$i][0])
			_IniVirtual_Delete($aServer, "DataList", $aConnectedUsers[$i][0])
			_IniVirtual_Delete($aServer, "USock2UIp", $aConnectedUsers[$i][0])
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$aConnectedUsers[$i][0]&"  IP  "&$aConnectedUsers[$i][1]&"   ."&@CRLF)
			ContinueLoop
			EndIF
		
		$vUserData = BinaryToString($vUserData)
			If $vUserData <> "" Then __HttpSC_ParseReqest($aConnectedUsers[$i][0], $aConnectedUsers[$i][1], $vUserData, $sGetFileFunc, $sPostFunc, $sOtherFunc, $aServer, $sLogFile)
	Next
	EndIF
$aConnectedUsers = 0
$vUserData = 0




; >> 		   		 << ;
$aUserDataList = _IniVirtual_ReadSection($aServer, "DataList")
	If NOT @Error Then
	For $i = 1 To $aUserDataList[0][0]
		If $aUserDataList[$i][1] = "" Then
			_IniVirtual_Delete($aServer, "DataList", $aUserDataList[$i][0])
			_IniVirtual_Delete($aServer, "USock2UIp", $aUserDataList[$i][0])
					If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    "&$aUserDataList[$i][0]&" !  ..."&@CRLF)
			TCPCloseSocket($aUserDataList[$i][0])
			ContinueLoop
		EndIF
		
		If StringLeft($aUserDataList[$i][1], 11) = "filehandle|" AND StringRight($aUserDataList[$i][1], 4) = "|---" Then
		__HttpSC_BigFile_Send($aUserDataList[$i][1], $aUserDataList[$i][0], $sLogFile, $aServer)
		ContinueLoop
		EndIF
		
		$iSendBytes = TCPSend($aUserDataList[$i][0], $aUserDataList[$i][1])
		If @Error Then
			_IniVirtual_Delete($aServer, "DataList", $aUserDataList[$i][0])
			_IniVirtual_Delete($aServer, "USock2UIp", $aUserDataList[$i][0])
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$aUserDataList[$i][0]&"       "&@CRLF)
			TCPCloseSocket($aUserDataList[$i][0])
			ContinueLoop
		EndIF
		
		If $iSendBytes > 0 Then $aUserDataList[$i][1] = StringTrimLeft($aUserDataList[$i][1], $iSendBytes)
		_IniVirtual_Write($aServer, "DataList", $aUserDataList[$i][0], $aUserDataList[$i][1])
	Next
	EndIF
Return SetError(1,0,0)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func __HttpSC_DebugWrite($hClientSocket, $shClientIP, $sStatus, $sReqest)
Local $sData
	If $s_HttpSC_DebugDir = "" Then Return 0

$sData = 		": "&@MDAY&"/"&@MON&"/"&@YEAR&@CRLF
$sData &= 	": "&@HOUR&":"&@MIN&":"&@SEC&@CRLF
$sData &= 	" : "&$hClientSocket&@CRLF
$sData &= 	"IP : "&$shClientIP&@CRLF
$sData &= 	": "&$sStatus&@CRLF&@CRLF
$sData &= 	">>>>>>>>>>>>>   <<<<<<<<<<<<<"&@CRLF
$sData &= 	$sReqest
$sData &= 	">>>>>>>>>>>>>   <<<<<<<<<<<<<"&@CRLF&@CRLF&@CRLF&@CRLF

DirCreate($s_HttpSC_DebugDir)
FileWrite($s_HttpSC_DebugDir&"\"&$hClientSocket&".txt", $sData)
Return 1
EndFunc








Func __HttpSC_ParseReqest($hClientSocket, $shClientIP, $sReqest, $sGetFileFunc, $sPostFunc, $sOtherFunc, ByRef $aServer, $sLogFile)
Local $aReturn[10], $aSplit, $sLine, $sUrl, $sHttpVer="", $hUserSocket, $sUserIp, $sServerSocket, $sServerIp, $sAnswer, $iSendBytes

	If StringLeft($sReqest, 4) = "GET " Then
	While 1
		$sUrl = StringTrimLeft($sReqest, 4)
		$aSplit = StringSplit($sUrl, @CRLF, 1)
			If @Error Then
			$sUrl = "/"
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"   GET !"&@CRLF)
			__HttpSC_DebugWrite($hClientSocket, $shClientIP, ":   (      URL)", $sReqest)
			ExitLoop
			EndIF
		
		$sLine = $aSplit[1]
		$aSplit = StringSplit($sLine, " HTTP", 1)
			If @Error Then
			$sUrl = "/"
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"   GET !"&@CRLF)
			__HttpSC_DebugWrite($hClientSocket, $shClientIP, ":   (   URL)", $sReqest)
			ExitLoop
			EndIF
		
		$sUrl = StringTrimRight($sLine, StringLen(" HTTP"&$aSplit[$aSplit[0]]))
		$sHttpVer = "HTTP"&$aSplit[$aSplit[0]]
		ExitLoop
	Wend
	
	__HttpSC_DebugWrite($hClientSocket, $shClientIP, " (get)", $sReqest)
	
	$sAnswer = Call($sGetFileFunc, $sUrl, $hClientSocket, $shClientIP, $sHttpVer, $sReqest)
		If IsArray($sAnswer) Then
			If $sAnswer[0] = 7 AND $sAnswer[1] = "filehandle" AND $sAnswer[7] = "---" Then
			__HttpSC_BigFile_Parse($sLogFile, $sAnswer, $hClientSocket, $aServer, $sUrl)
			Return SetError(0,0,$sUrl)
			Else
			$sAnswer = ""
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [ERR] 	>  ,  "&$hClientSocket&"  !"&@CRLF)
			EndIF
		EndIF
		
		If $sAnswer = "" Then
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"      "&$sUrl&@CRLF)
		Return SetError(-1,0,$sUrl)
		EndIF
	
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"   "&$sUrl&@CRLF)
	
	$iSendBytes = TCPSend ($hClientSocket, $sAnswer)
		If $iSendBytes > 0 Then $sAnswer = StringTrimLeft($sAnswer, $iSendBytes)
	
	_IniVirtual_Write($aServer, "DataList", $hClientSocket, $sAnswer)
	Return SetError(0,0,$sUrl)
	EndIF





	If StringLeft($sReqest, 5) = "POST " Then
	While 1
		$sUrl = StringTrimLeft($sReqest, 5)
		$aSplit = StringSplit($sUrl, @CRLF, 1)
			If @Error Then
			$sUrl = "/"
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"   POST !"&@CRLF)
			__HttpSC_DebugWrite($hClientSocket, $shClientIP, ":  POST  (      URL)", $sReqest)
			ExitLoop
			EndIF
		
		$sLine = $aSplit[1]
		$aSplit = StringSplit($sLine, "HTTP", 1)
			If @Error Then
			$sUrl = "/"
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"   POST !"&@CRLF)
			__HttpSC_DebugWrite($hClientSocket, $shClientIP, ":  POST  (   URL)", $sReqest)
			ExitLoop
			EndIF
		
		$sUrl = StringTrimRight($sLine, StringLen(" HTTP"&$aSplit[$aSplit[0]]))
		$sHttpVer = "HTTP"&$aSplit[$aSplit[0]]
		ExitLoop
	Wend
	
	__HttpSC_DebugWrite($hClientSocket, $shClientIP, " (post)", $sReqest)
	
	$sAnswer = Call($sPostFunc, $sUrl, $hClientSocket, $shClientIP, $sHttpVer, $sReqest)
		If IsArray($sAnswer) Then
			If $sAnswer[0] = 7 AND $sAnswer[1] = "filehandle" AND $sAnswer[7] = "---" Then
			__HttpSC_BigFile_Parse($sLogFile, $sAnswer, $hClientSocket, $aServer, $sUrl)
			Return SetError(0,0,$sUrl)
			Else
			$sAnswer = ""
				If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [ERR] 	>  ,  "&$hClientSocket&"  !"&@CRLF)
			EndIF
		EndIF

		If $sAnswer = "" Then
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"    POST  "&$sUrl&@CRLF)
		Return SetError(-1,0,$sUrl)
		EndIF
	
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"  POST  "&$sUrl&@CRLF)
	
	$iSendBytes = TCPSend ($hClientSocket, $sAnswer)
		If $iSendBytes > 0 Then $sAnswer = StringTrimLeft($sAnswer, $iSendBytes)
	
	_IniVirtual_Write($aServer, "DataList", $hClientSocket, $sAnswer)
	Return SetError(0,0,$sUrl)
	EndIF





__HttpSC_DebugWrite($hClientSocket, $shClientIP, " (?)", $sReqest)
$sAnswer = Call($sOtherFunc, $hUserSocket, $sUserIp, $sReqest)
	If $sAnswer = "" Then
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"     "&@CRLF)
	Return SetError(-1,0,"")
	EndIF

	If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"  "&@CRLF)

$iSendBytes = TCPSend ($hClientSocket, $sAnswer)
	If $iSendBytes > 0 Then $sAnswer = StringTrimLeft($sAnswer, $iSendBytes)

_IniVirtual_Write($aServer, "DataList", $hClientSocket, $sAnswer)
Return SetError(0,0,"")
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ServerOptimization(ByRef $aServer, $fForced=0)
Local $iNull=0, $sINI, $i, $sLogFile
$sLogFile = _IniVirtual_Read($aServer, "Server", "LogFile", "")
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,0)

	If NOT $fForced Then
		For $i = 1 To $aServer[0][0]
			If $aServer[$i][0] = "" Then $iNull += 1
		Next
		If ($aServer[0][0]/3) > $iNull Then
			$fForced = 1
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>   "&@CRLF)
		Else
			If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>    "&@CRLF)
		EndIF
	EndIF

	If $fForced Then
	Local $aNewIni[$aServer[0][0]+1][3], $iWrited
	$aNewIni[0][0] = $aServer[0][0]
	$aNewIni[0][1] = 0
	$aNewIni[0][2] = "IniVirtual data"
	$iNull = 0
	$iWrited = 0
	
	For $i = 1 To $aServer[0][0]
		If $aServer[$i][0] = "" Then
		$iNull += 1
		Else
		$iWrited += 1
		$aNewIni[$iWrited][0] = $aServer[$i][0]
		$aNewIni[$iWrited][1] = $aServer[$i][1]
		$aNewIni[$iWrited][2] = $aServer[$i][2]
		EndIF
	Next
	
	$aNewIni[0][0] = $iWrited 
	ReDim $aNewIni[$iWrited +1][3]
	$aServer = $aNewIni
	$aNewIni = 0
		#CS
		If $iNull < 1 Then $iNull = $aServer[0][0]
		$sINI = _IniVirtual_Save($aServer)
		$aServer = _IniVirtual_Initial($sINI)
		#CE
	EndIF

Return SetError(0,0,$iNull)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ServerGet_ConnUsers(ByRef $aServer)
Local $aReturn, $aDef[1][2] = [[0]]
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,$aDef)

$aReturn = _IniVirtual_ReadSection($aServer, "USock2UIp")
	If @Error Then Return SetError(11,0,$aDef)

Return SetError(0,$aReturn[0][0],$aReturn)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ServerGet_ServerSockets(ByRef $aServer)
Local $aReturn, $aDef[1][2] = [[0]]
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,$aDef)

$aReturn = _IniVirtual_ReadSection($aServer, "Ip2Sock")
	If @Error Then Return SetError(11,0,$aDef)

Return SetError(0,$aReturn[0][0],$aReturn)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_ServerGet_BannedUsersIp(ByRef $aServer)
Local $aReturn2D, $aDef[1]=[0], $aReturn[1]=[0]
	If _IniVirtual_Read($aServer, "Server", "Port", "") = "" Then Return SetError(6,0,$aDef)

$aReturn2D = _IniVirtual_ReadSection($aServer, "BannedUsers")
	If @Error Then Return SetError(11,0,$aDef)

$aReturn[0] = $aReturn2D[0][0]
ReDim $aReturn[$aReturn[0]+1]
For $i = 1 To $aReturn[0]
	$aReturn[$i] = $aReturn2D[$i][0]
Next

Return SetError(0,$aReturn[0],$aReturn)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_PostReqestGetData($sReqest, $fConvert=0)
Local $sSplit, $iContentLength, $aSplit, $i, $aData, $aReturn[1][2]

$iContentLength = _HttpSC_ReqestParse($sReqest, "Content-Length")
	If @Error Then Return SetError(12, 0, "")

$sSplit = StringRight($sReqest, $iContentLength)
	If NOT $fConvert Then Return SetError(0, $iContentLength, $sSplit)

$aReturn[0][0] = 0

$aSplit = StringSplit($sSplit, "&")
	If NOT @Error Then
		For $i = 1 To $aSplit[0]
			$aData = StringSplit($aSplit[$i], "=")
				If @Error OR $aData[0] < 2 Then ContinueLoop
			$aReturn[0][0] += 1
			ReDim $aReturn[$aReturn[0][0]+1][2]
			$aReturn[$aReturn[0][0]][0] = __HttpSC_Encoding_URIDecode($aData[1])
			$aReturn[$aReturn[0][0]][1] = __HttpSC_Encoding_URIDecode( StringTrimLeft($aSplit[$i], StringLen($aData[1])+1) )
		Next
		Return SetError(0, $iContentLength, $aReturn)
	Else
		$aData = StringSplit($sSplit, "=")
			If @Error OR $aData[0] < 2 Then Return SetError(9, 0, "")
		$aReturn[0][0] += 1
		ReDim $aReturn[$aReturn[0][0]+1][2]
		$aReturn[$aReturn[0][0]][0] = __HttpSC_Encoding_URIDecode($aData[1])
		$aReturn[$aReturn[0][0]][1] = __HttpSC_Encoding_URIDecode( StringTrimLeft($sSplit, StringLen($aData[1])+1) )
		Return SetError(0, $iContentLength, $aReturn)
	EndIF

Return SetError(9, 0, "")
EndFunc




;Description: Decode string from URI format (Uniform Resource Identifier)
;Author: CreatoR
;   Encoding.au3
;   -: _Encoding_URIDecode
Func __HttpSC_Encoding_URIDecode($sString)
	Local $oSC = ObjCreate("ScriptControl")
	$oSC.Language = "JavaScript"
	Local $Encode_URI = $oSC.Eval("decodeURI('" & $sString & "');")

	$oSC = 0

	Return $Encode_URI
EndFunc   ;==>_Encoding_URIDecode

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_BasicAuthenticate_GetData($sReqest)
Local $sSplit, $aSplit, $aReturn[2]=["", ""]

$sSplit = _HttpSC_ReqestParse($sReqest, "Authorization")
	If @Error Then Return SetError(8, 0, $aReturn)

$aSplit = StringSplit($sSplit, "Basic ", 1)
	If @Error OR $aSplit[0] < 2 Then Return SetError(9, 0, $aReturn)

$sSplit = __HttpSC_Encoding_Base64Decode($aSplit[2])

$aSplit = StringSplit($sSplit, ":")
	If @Error OR $aSplit[0] < 2 Then Return SetError(9, 0, $aReturn)

$aReturn[0] = $aSplit[1]
$aReturn[1] = StringTrimLeft($sSplit, StringLen($aSplit[1])+1)

Return SetError(0, 0, $aReturn)
EndFunc




;Description: Decode string from Base64 data format
;Author: trancexx
;   Encoding.au3
;   -: _Encoding_Base64Decode
Func __HttpSC_Encoding_Base64Decode($sData)
Local $struct, $a_Call, $a
	$struct = DllStructCreate("int")
	
	$a_Call = DllCall("Crypt32.dll", "int", "CryptStringToBinary", _
			"str", $sData, _
			"int", 0, _
			"int", 1, _
			"ptr", 0, _
			"ptr", DllStructGetPtr($struct, 1), _
			"ptr", 0, _
			"ptr", 0)
	
	If @error Or Not $a_Call[0] Then
		Return SetError(1, 0, "") ; error calculating the length of the buffer needed
	EndIf
	
	$a = DllStructCreate("byte[" & DllStructGetData($struct, 1) & "]")
	
	$a_Call = DllCall("Crypt32.dll", "int", "CryptStringToBinary", _
			"str", $sData, _
			"int", 0, _
			"int", 1, _
			"ptr", DllStructGetPtr($a), _
			"ptr", DllStructGetPtr($struct, 1), _
			"ptr", 0, _
			"ptr", 0)
	
	If @error Or Not $a_Call[0] Then
		Return SetError(2, 0, ""); error decoding
	EndIf
	
	Return BinaryToString(DllStructGetData($a, 1))
EndFunc   ;==>_Encoding_Base64Decode

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func _HttpSC_CreateBigFileAnswer(ByRef $aServer, $sFilePutch, $sHttpVersion="HTTP/1.1", $sAnswerCode="200 Ok",  $aLastModified="", $sContentType="text/html", $sAdditionalHeaders="", $sAuthenticateRealm="")
Local $sDefAnswerData, $sRetAnswerData, $hFile, $vRead, $iSize, $aAnswer[8]
$sDefAnswerData = "[!&filehandle&-]"

#CS
	[0] = 7
	[1] = "filehandle"
	[2] =   
	[3] =  
	[4] =   
	[5] =    
	[6] =   
	[7] = "---"
#CE

$iSize = FileGetSize($sFilePutch)
	If $iSize < 1 Then Return SetError(13,0,"")

$sRetAnswerData = _HttpSC_CreateAnswer($aServer, $sDefAnswerData, $sHttpVersion, $sAnswerCode, $aLastModified, $sContentType, $sAdditionalHeaders, $sAuthenticateRealm) 
	If @Error Then Return SetError(@Error, @Extended, $sRetAnswerData)

$sRetAnswerData = StringReplace($sRetAnswerData, "Content-Length: "&StringLen($sDefAnswerData), "Content-Length: "&$iSize)

$hFile = FileOpen($sFilePutch, 0+16)
	If $hFile < 1 Then Return SetError(14,0,"")

$vRead = BinaryToString(FileRead($hFile, 5))
$sRetAnswerData = StringReplace($sRetAnswerData, $sDefAnswerData, "")
$sRetAnswerData = $sRetAnswerData&$vRead

$aAnswer[0] = 7
$aAnswer[1] = "filehandle"
$aAnswer[2] = $sFilePutch
$aAnswer[3] = $hFile
$aAnswer[4] = $sRetAnswerData
$aAnswer[5] = $iSize
$aAnswer[6] = FileGetPos($hFile)
$aAnswer[7] = "---"

Return SetError(0,0,$aAnswer)
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func __HttpSC_BigFile_Parse($sLogFile, $aAnswer, $hClientSocket, ByRef $aServer, $sUrl)
Local $iSendBytes=0, $sAnswer

While 1
$iSendBytes = TCPSend ($hClientSocket, $aAnswer[4])
	If @Error Then
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&" ."&@CRLF)
		TCPCloseSocket($hClientSocket)
		_IniVirtual_Delete($aServer, "DataList", $hClientSocket)
		_IniVirtual_Delete($aServer, "USock2UIp", $hClientSocket)
		FileClose($aAnswer[3])
		Return 0
		EndIF
	If $iSendBytes > 0 Then $aAnswer[4] = StringTrimLeft($aAnswer[4], $iSendBytes)
	If $aAnswer[4] = "" Then ExitLoop
Wend
$aAnswer[4] = ""


#CS
	[0] = 7
	[1] = "filehandle"
	[2] =   
	[3] =  
	[4] =   
	[5] =    
	[6] =   
	[7] = "---"
#CE

$sAnswer = $aAnswer[1]&"|"&$aAnswer[2]&"|"&$aAnswer[3]&"|"&$aAnswer[4]&"|"&$aAnswer[5]&"|"&$aAnswer[6]&"|"&$aAnswer[7]
	If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"    "&$sUrl&@CRLF)

_IniVirtual_Write($aServer, "DataList", $hClientSocket, $sAnswer)
Return 1
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Func __HttpSC_BigFile_Send($sBfData, $hClientSocket, $sLogFile, ByRef $aServer)
Local $aAnswer, $vRead, $iBytes, $iSendBytes, $sAnswer, $iBigFilePacketSizeMb
#CS
	[0] = 7
	[1] = "filehandle"
	[2] =   
	[3] =  
	[4] =   
	[5] =    
	[6] =   
	[7] = "---"
#CE


$aAnswer = StringSplit($sBfData, "|")
	If @Error OR $aAnswer[0] <> 7 Then
	_IniVirtual_Delete($aServer, "DataList", $hClientSocket)
	_IniVirtual_Delete($aServer, "USock2UIp", $hClientSocket)
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [ERR] 	>      "&$hClientSocket&". ParseError.  !"&@CRLF)
	TCPCloseSocket($hClientSocket)
	FileClose($aAnswer[3])
	Return 0
	EndIF
$aAnswer[3] = $aAnswer[3]*1

$iBigFilePacketSizeMb = _IniVirtual_Read($aServer, "Config", "BigFilePacketSizeMb", "5")
	If $iBigFilePacketSizeMb < 1 Then $iBigFilePacketSizeMb = 1
$iBigFilePacketSizeMb = $iBigFilePacketSizeMb*1048576


	If FileGetSize($aAnswer[2]) <> $aAnswer[5] Then
	_IniVirtual_Delete($aServer, "DataList", $hClientSocket)
	_IniVirtual_Delete($aServer, "USock2UIp", $hClientSocket)
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [ERR] 	>      "&$hClientSocket&". FileSizeError.  !"&@CRLF)
	TCPCloseSocket($hClientSocket)
	FileClose($aAnswer[3])
	Return 0
	EndIF


$vRead = FileRead($aAnswer[3], $iBigFilePacketSizeMb)
$iBytes = @extended
$vRead = BinaryToString($vRead)
	If $iBytes < 1 Then
	_IniVirtual_Delete($aServer, "DataList", $hClientSocket)
	_IniVirtual_Delete($aServer, "USock2UIp", $hClientSocket)
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OR] 	>     "&$hClientSocket&" ."&@CRLF)
	TCPCloseSocket($hClientSocket)
	FileClose($aAnswer[3])
	Return 0
	EndIF

$iSendBytes = TCPSend ($hClientSocket, $vRead)
	If @Error Then
	_IniVirtual_Delete($aServer, "DataList", $hClientSocket)
	_IniVirtual_Delete($aServer, "USock2UIp", $hClientSocket)
		If $sLogFile <> "" Then FileWrite($sLogFile, @MDAY&"/"&@MON&"/"&@YEAR&"("&@HOUR&":"&@MIN&":"&@SEC&") [OK] 	>  "&$hClientSocket&"    !"&@CRLF)
	TCPCloseSocket($hClientSocket)
	FileClose($aAnswer[3])
	Return 0
	EndIF

	If $iSendBytes < $iBytes Then
	FileSetPos($aAnswer[3], FileGetPos($aAnswer[3])-$iBytes+$iSendBytes, 0)
	EndIF
	

$sAnswer = $aAnswer[1]&"|"&$aAnswer[2]&"|"&$aAnswer[3]&"|"&$aAnswer[4]&"|"&$aAnswer[5]&"|"&$aAnswer[6]&"|"&$aAnswer[7]
_IniVirtual_Write($aServer, "DataList", $hClientSocket, $sAnswer)
Return 1
EndFunc

; /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






























